# Hooks Reference

A list of hooks, e.g. `actions` and `filters`, that are defined or used in this project.

## automatewoo/action/after_preview

**Type**: action

**Used in**:

- [ajax.php#L391](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/ajax.php#L391)

## automatewoo/action/before_preview

**Type**: action

**Used in**:

- [ajax.php#L383](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/ajax.php#L383)

## automatewoo/admin/analytics_enabled

**Type**: filter

**Used in**:

- [Analytics.php#L116](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/Analytics.php#L116)

## automatewoo/admin/asset_data

**Type**: filter

**Used in**:

- [AssetData.php#L47](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/AssetData.php#L47)

## automatewoo/admin/controllers/includes

**Type**: filter

**Used in**:

- [controllers.php#L43](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers.php#L43)

## automatewoo/admin/js_settings

**Type**: filter

**Used in**:

- [admin.php#L472](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/admin.php#L472)

## automatewoo/admin/screen_ids

**Type**: filter

**Used in**:

- [admin.php#L615](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/admin.php#L615)

## automatewoo/admin/settings/->GET_ID

**Type**: action

**Used in**:

- [abstract.php#L93](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/settings-tabs/abstract.php#L93)

## automatewoo/admin/submenu_pages

**Type**: action

**Used in**:

- [admin.php#L315](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/admin.php#L315)

## automatewoo/dashboard/chart_widgets

**Type**: filter

**Used in**:

- [dashboard.php#L102](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/dashboard.php#L102)

## automatewoo/dashboard/date_range

**Type**: filter

**Used in**:

- [dashboard.php#L176](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/dashboard.php#L176)

## automatewoo/dashboard/key_figures

**Type**: filter

**Used in**:

- [key-figures.php#L60](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/dashboard-widgets/key-figures.php#L60)

## automatewoo/dashboard/widgets

**Type**: filter

**Used in**:

- [dashboard.php#L109](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/dashboard.php#L109)

## automatewoo/email_preview/html

**Type**: action

**Used in**:

- [ajax.php#L396](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/ajax.php#L396)

## automatewoo/email_preview/send_test

**Type**: action

**Used in**:

- [ajax.php#L446](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/ajax.php#L446)

## automatewoo/email_preview/subject

**Type**: filter

**Used in**:

- [preview.php#L65](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/preview.php#L65)

## automatewoo/email_preview/template

**Type**: filter

**Used in**:

- [preview.php#L66](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/preview.php#L66)

## automatewoo/formatted_data_layer

**Type**: filter

**Used in**:

- [data-layer-formatter.php#L158](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/data-layer-formatter.php#L158)

## automatewoo/reports/tabs

**Type**: filter

**Used in**:

- [reports.php#L90](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/reports.php#L90)

## automatewoo/settings/tabs

**Type**: filter

**Used in**:

- [settings.php#L69](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/controllers/settings.php#L69)

## automatewoo/workflow/timing_options

**Type**: filter

**Used in**:

- [meta-box-timing.php#L20](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/views/meta-box-timing.php#L20)

## automatewoo_report_items_per_page

**Type**: filter

**Used in**:

- [conversions-list.php#L158](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/reports/conversions-list.php#L158)

## woocommerce_json_search_found_products

**Type**: filter

**Used in**:

- [json-search.php#L68](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/json-search.php#L68)

## woocommerce_json_search_limit

**Type**: filter

**Used in**:

- [json-search.php#L42](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/admin/json-search.php#L42)

## [filter]

**Type**: filter

**Used in**:

- [Shop_Products.php#L180](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Shop_Products.php#L180)

## BookingCreated->GET_HOOK_NAME

**Type**: action

**Used in**:

- [BookingCreated.php#L151](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/BookingCreated.php#L151)

## Order_Created->GET_HOOK_NAME

**Type**: action

**Used in**:

- [Order_Created.php#L115](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/Order_Created.php#L115)

## Order_Paid->GET_HOOK_NAME

**Type**: action

**Used in**:

- [Order_Paid.php#L66](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/Order_Paid.php#L66)

## automatewoo/actions

**Type**: filter

**Used in**:

- [Actions.php#L112](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions.php#L112)

## automatewoo/active_triggers

**Type**: filter

**Used in**:

- [Active_Triggers_Cache.php#L56](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Active_Triggers_Cache.php#L56)

## automatewoo/admin_notice/

**Type**: action

**Used in**:

- [AdminNotices.php#L112](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AdminNotices.php#L112)

## automatewoo/ajax/before_send_json

**Type**: action

**Used in**:

- [Ajax.php#L86](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Ajax.php#L86)
- [Ajax.php#L95](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Ajax.php#L95)

## automatewoo/ajax/sanitize_text_field

**Type**: action

**Used in**:

- [Ajax.php#L77](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Ajax.php#L77)

## automatewoo/anonymize_email

**Type**: filter

**Used in**:

- [helpers.php#L509](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/helpers.php#L509)

## automatewoo/async_events/after_init_required_events

**Type**: action

**Used in**:

- [Async_Events.php#L148](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events.php#L148)

## automatewoo/async_events/always_required_events

**Type**: filter

**Used in**:

- [Async_Events.php#L94](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events.php#L94)

## automatewoo/async_events/includes

**Type**: filter

**Used in**:

- [Async_Events.php#L70](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events.php#L70)

## automatewoo/async_events/required_events

**Type**: filter

**Used in**:

- [Async_Events.php#L131](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events.php#L131)

## automatewoo/batched_job_monitor/failure_rate_threshold

**Type**: filter

**Used in**:

- [ActionSchedulerJobMonitor.php#L63](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/ActionSchedulerJobMonitor.php#L63)

## automatewoo/bitly/shorten_url

**Type**: filter

**Used in**:

- [Bitly.php#L77](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Integrations/Bitly.php#L77)

## automatewoo/cart/get_item_count

**Type**: filter

**Used in**:

- [Cart.php#L395](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart.php#L395)

## automatewoo/cart/get_items

**Type**: filter

**Used in**:

- [Cart.php#L344](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart.php#L344)

## automatewoo/cart/get_shipping_total_html

**Type**: filter

**Used in**:

- [Cart.php#L243](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart.php#L243)

## automatewoo/cart/price_args

**Type**: filter

**Used in**:

- [Cart.php#L555](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart.php#L555)

## automatewoo/cart/restored

**Type**: action

**Used in**:

- [CartRestorer.php#L80](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Carts/CartRestorer.php#L80)

## automatewoo/cart/status_changed

**Type**: action

**Used in**:

- [Cart.php#L76](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart.php#L76)

## automatewoo/cart/statuses

**Type**: filter

**Used in**:

- [Carts.php#L100](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Carts.php#L100)

## automatewoo/cart_item/get_quantity

**Type**: filter

**Used in**:

- [Cart_Item.php#L177](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart_Item.php#L177)

## automatewoo/checkout_capture_fields

**Type**: filter

**Used in**:

- [PreSubmit.php#L30](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/PreSubmit.php#L30)

## automatewoo/click_track/safe_redirect_fallback

**Type**: filter

**Used in**:

- [Tracking.php#L117](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Tracking.php#L117)

## automatewoo/communication_page/legal_text

**Type**: filter

**Used in**:

- [Frontend.php#L33](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend.php#L33)

## automatewoo/communication_page/save_preferences

**Type**: action

**Used in**:

- [Frontend_Form_Handler.php#L109](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Form_Handler.php#L109)

## automatewoo/communication_tab/endpoint

**Type**: filter

**Used in**:

- [Communication_Account_Tab.php#L18](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Communication_Account_Tab.php#L18)

## automatewoo/communication_tab/menu_title

**Type**: filter

**Used in**:

- [Communication_Account_Tab.php#L44](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Communication_Account_Tab.php#L44)

## automatewoo/communication_tab/page_title

**Type**: filter

**Used in**:

- [Communication_Account_Tab.php#L36](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Communication_Account_Tab.php#L36)

## automatewoo/conversion/recorded

**Type**: action

**Used in**:

- [Conversions.php#L61](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Conversions.php#L61)

## automatewoo/conversions/is_valid_conversion

**Type**: filter

**Used in**:

- [Conversions.php#L116](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Conversions.php#L116)

## automatewoo/counted_order_statuses

**Type**: filter

**Used in**:

- [helpers.php#L254](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/helpers.php#L254)

## automatewoo/coupon_generator/code

**Type**: filter

**Used in**:

- [Coupon_Generator.php#L142](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Coupon_Generator.php#L142)

## automatewoo/coupon_generator/generate_from_template_coupon

**Type**: action

**Used in**:

- [Coupon_Generator.php#L240](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Coupon_Generator.php#L240)

## automatewoo/coupon_generator/key_length

**Type**: filter

**Used in**:

- [Coupon_Generator.php#L140](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Coupon_Generator.php#L140)

## automatewoo/coupons/days_to_keep_expired

**Type**: filter

**Used in**:

- [DeleteExpiredCoupons.php#L66](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/DeleteExpiredCoupons.php#L66)

## automatewoo/customer/before_is_unsubscribed

**Type**: action

**Used in**:

- [Customer.php#L157](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customer.php#L157)

## automatewoo/customer/converted_guest_to_registered_customer

**Type**: action

**Used in**:

- [Customers.php#L105](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customers.php#L105)

## automatewoo/customer/get_language

**Type**: filter

**Used in**:

- [Customer.php#L683](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customer.php#L683)

## automatewoo/customer/is_unsubscribed

**Type**: filter

**Used in**:

- [Customer.php#L166](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customer.php#L166)

## automatewoo/customer/opted_in

**Type**: action

**Used in**:

- [Customer.php#L198](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customer.php#L198)

## automatewoo/customer/opted_out

**Type**: action

**Used in**:

- [Customer.php#L214](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Customer.php#L214)

## automatewoo/data_layer/init

**Type**: action

**Used in**:

- [Data_Layer.php#L47](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Data_Layer.php#L47)

## automatewoo/data_types/includes

**Type**: filter

**Used in**:

- [DataTypes.php#L63](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/DataTypes/DataTypes.php#L63)

## automatewoo/database_tables

**Type**: filter

**Used in**:

- [Database_Tables.php#L50](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Database_Tables.php#L50)

## automatewoo/email/before_send

**Type**: action

**Used in**:

- [Mailer_Abstract.php#L179](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer_Abstract.php#L179)

## automatewoo/email/plain_text_unsubscribe_footer

**Type**: filter

**Used in**:

- [Workflow_Email.php#L330](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow_Email.php#L330)

## automatewoo/email/product_image

**Type**: filter

**Used in**:

- [mailer-api.php#L104](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/mailer-api.php#L104)

## automatewoo/email/product_placeholder_image

**Type**: filter

**Used in**:

- [mailer-api.php#L106](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/mailer-api.php#L106)

## automatewoo/factories

**Type**: filter

**Used in**:

- [Factories.php#L23](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Factories.php#L23)

## automatewoo/gmt_offset_changed

**Type**: action

**Used in**:

- [CheckGmtOffsetChange.php#L43](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/CheckGmtOffsetChange.php#L43)

## automatewoo/guest/locking_timeout

**Type**: filter

**Used in**:

- [Guest.php#L427](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Guest.php#L427)

## automatewoo/guest_capture_fields

**Type**: filter

**Used in**:

- [PreSubmit.php#L17](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/PreSubmit.php#L17)

## automatewoo/honeypot_field/name

**Type**: filter

**Used in**:

- [Frontend_Form_Handler.php#L30](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Form_Handler.php#L30)

## automatewoo/intervals/->GET_NAME

**Type**: filter

**Used in**:

- [AbstractActionSchedulerJob.php#L69](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/AbstractActionSchedulerJob.php#L69)

## automatewoo/jobs

**Type**: filter

**Used in**:

- [JobRegistry.php#L138](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/JobRegistry.php#L138)

## automatewoo/log/data_layer_storage_keys

**Type**: filter

**Used in**:

- [Logs.php#L24](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Logs.php#L24)

## automatewoo/mailer/blacklist

**Type**: filter

**Used in**:

- [Mailer_Abstract.php#L154](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer_Abstract.php#L154)

## automatewoo/mailer/from_address

**Type**: filter

**Used in**:

- [Emails.php#L88](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Emails.php#L88)

## automatewoo/mailer/from_name

**Type**: filter

**Used in**:

- [Emails.php#L57](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Emails.php#L57)

## automatewoo/mailer/init

**Type**: action

**Used in**:

- [Mailer.php#L58](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L58)

## automatewoo/mailer/styles

**Type**: filter

**Used in**:

- [Mailer.php#L255](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L255)

## automatewoo/mailer/variable_value

**Type**: filter

**Used in**:

- [Mailer_Abstract.php#L254](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer_Abstract.php#L254)

## automatewoo/mailer_raw/styles

**Type**: filter

**Used in**:

- [Mailer_Raw_HTML.php#L30](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer_Raw_HTML.php#L30)

## automatewoo/notifications/includes

**Type**: filter

**Used in**:

- [Notifications.php#L66](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Notifications.php#L66)

## automatewoo/notifications/loaded

**Type**: filter

**Used in**:

- [NotificationsInitializer.php#L126](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/NotificationsInitializer.php#L126)

## automatewoo/object/create

**Type**: action

**Used in**:

- [Model.php#L228](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Model.php#L228)

## automatewoo/object/delete

**Type**: action

**Used in**:

- [Model.php#L246](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Model.php#L246)

## automatewoo/object/load

**Type**: action

**Used in**:

- [Model.php#L62](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Model.php#L62)

## automatewoo/object/update

**Type**: action

**Used in**:

- [Model.php#L206](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Model.php#L206)

## automatewoo/order/paid

**Type**: action

**Used in**:

- [Order_Paid.php#L69](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/Order_Paid.php#L69)

## automatewoo/preview_data_layer

**Type**: filter

**Used in**:

- [Preview_Data.php#L314](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Preview_Data.php#L314)

## automatewoo/privacy/erase_user_meta

**Type**: action

**Used in**:

- [Privacy_Erasers.php#L200](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Privacy_Erasers.php#L200)

## automatewoo/privacy/exported_customer_data

**Type**: filter

**Used in**:

- [Privacy_Exporters.php#L103](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Privacy_Exporters.php#L103)

## automatewoo/privacy/exported_data_layer

**Type**: filter

**Used in**:

- [Privacy_Exporters.php#L385](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Privacy_Exporters.php#L385)

## automatewoo/privacy/loaded

**Type**: action

**Used in**:

- [Privacy.php#L35](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Privacy.php#L35)

## automatewoo/privacy_policy_guide

**Type**: filter

**Used in**:

- [Privacy_Policy_Guide.php#L56](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Privacy_Policy_Guide.php#L56)

## automatewoo/products/gone_on_sale

**Type**: action

**Used in**:

- [ProductGoesOnSale.php#L46](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/ProductGoesOnSale.php#L46)

## automatewoo/query/get_count_sql

**Type**: filter

**Used in**:

- [Query_Abstract.php#L449](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Query_Abstract.php#L449)

## automatewoo/query/get_results_sql

**Type**: filter

**Used in**:

- [Query_Abstract.php#L388](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Query_Abstract.php#L388)

## automatewoo/review/posted

**Type**: action

**Used in**:

- [Review_Posted.php#L59](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Event_Helpers/Review_Posted.php#L59)

## automatewoo/rules/includes

**Type**: filter

**Used in**:

- [Rules.php#L170](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Rules.php#L170)

## automatewoo/rules/preloaded_select/choices

**Type**: filter

**Used in**:

- [Preloaded_Select_Rule_Abstract.php#L40](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Rules/Preloaded_Select_Rule_Abstract.php#L40)

## automatewoo/rules/validate_logical_empty_date

**Type**: filter

**Used in**:

- [Abstract_Date.php#L530](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Rules/Abstract_Date.php#L530)

## automatewoo/session_tracker/cookie_name

**Type**: filter

**Used in**:

- [Session_Tracker.php#L34](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Session_Tracker.php#L34)

## automatewoo/session_tracker/new_stored_guest

**Type**: action

**Used in**:

- [Session_Tracker.php#L442](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Session_Tracker.php#L442)

## automatewoo/session_tracking/cookies_permitted

**Type**: filter

**Used in**:

- [Session_Tracker.php#L137](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Session_Tracker.php#L137)

## automatewoo/sms/is_recipient_primary_customer

**Type**: filter

**Used in**:

- [Send_SMS_Twilio.php#L149](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Send_SMS_Twilio.php#L149)

## automatewoo/stored_cart/created_via_frontend

**Type**: action

**Used in**:

- [Carts.php#L194](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Carts.php#L194)

## automatewoo/stored_cart/deleted_via_frontend

**Type**: action

**Used in**:

- [Carts.php#L164](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Carts.php#L164)

## automatewoo/stored_cart/updated_via_frontend

**Type**: action

**Used in**:

- [Carts.php#L173](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Carts.php#L173)

## automatewoo/subscription/status_changed

**Type**: action

**Used in**:

- [Subscription_Status_Changed.php#L60](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Event_Helpers/Subscription_Status_Changed.php#L60)

## automatewoo/system_checks

**Type**: filter

**Used in**:

- [System_Checks.php#L25](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/System_Checks.php#L25)
- [SystemChecks.php#L91](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Notifications/SystemChecks.php#L91)

## automatewoo/tools

**Type**: filter

**Used in**:

- [ToolsService.php#L53](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Tools/ToolsService.php#L53)

## automatewoo/tracking/excluded_user_agents

**Type**: filter

**Used in**:

- [Tracking.php#L132](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Tracking.php#L132)

## automatewoo/trigger/workflows

**Type**: filter

**Used in**:

- [Trigger.php#L264](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Trigger.php#L264)

## automatewoo/triggers

**Type**: filter

**Used in**:

- [Triggers.php#L134](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Triggers.php#L134)

## automatewoo/usage_tracking/addon_base_properties

**Type**: filter

**Used in**:

- [Tracks.php#L47](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Usage_Tracking/Tracks.php#L47)

## automatewoo/usage_tracking/addon_tracking_classes

**Type**: filter

**Used in**:

- [Initializer.php#L58](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Usage_Tracking/Initializer.php#L58)

## automatewoo/usage_tracking/enabled

**Type**: filter

**Used in**:

- [Initializer.php#L30](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Usage_Tracking/Initializer.php#L30)

## automatewoo/usage_tracking/init

**Type**: action

**Used in**:

- [Initializer.php#L34](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Usage_Tracking/Initializer.php#L34)

## automatewoo/usage_tracking/workflow_data

**Type**: filter

**Used in**:

- [WorkflowTracksData.php#L50](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Usage_Tracking/WorkflowTracksData.php#L50)

## automatewoo/user_registered

**Type**: action

**Used in**:

- [User_Registration.php#L54](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Event_Helpers/User_Registration.php#L54)

## automatewoo/variables

**Type**: filter

**Used in**:

- [Variables.php#L294](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables.php#L294)

## automatewoo/variables/after_get_value

**Type**: filter

**Used in**:

- [Variables_Processor.php#L70](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables_Processor.php#L70)

## automatewoo/variables/coupons/use_email_restriction

**Type**: filter

**Used in**:

- [Abstract_Generate_Coupon.php#L71](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Abstract_Generate_Coupon.php#L71)

## automatewoo/variables/date_format_options

**Type**: filter

**Used in**:

- [Abstract_Datetime.php#L67](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Abstract_Datetime.php#L67)

## automatewoo/variables/generate_coupon

**Type**: filter

**Used in**:

- [Abstract_Generate_Coupon.php#L114](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Abstract_Generate_Coupon.php#L114)

## automatewoo/variables/get_variable_value

**Type**: filter

**Used in**:

- [Variables_Processor.php#L145](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables_Processor.php#L145)

## automatewoo/variables/product_templates

**Type**: filter

**Used in**:

- [Abstract_Product_Display.php#L46](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Abstract_Product_Display.php#L46)

## automatewoo/variables_processor/excluded

**Type**: filter

**Used in**:

- [VariableParser.php#L111](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows/VariableParsing/VariableParser.php#L111)

## automatewoo/workflow/before_run

**Type**: action

**Used in**:

- [Workflow.php#L427](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L427)

## automatewoo/workflow/created

**Type**: action

**Used in**:

- [Workflows.php#L75](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows.php#L75)
- [Factory.php#L112](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows/Factory.php#L112)

## automatewoo/workflow/deleted

**Type**: action

**Used in**:

- [Workflows.php#L84](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows.php#L84)

## automatewoo/workflow/is_customer_unsubscribed

**Type**: filter

**Used in**:

- [Workflow.php#L1175](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1175)

## automatewoo/workflow/is_exempt_from_unsubscribing

**Type**: filter

**Used in**:

- [Workflow.php#L1226](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1226)

## automatewoo/workflow/location

**Type**: filter

**Used in**:

- [Workflow.php#L1707](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1707)

## automatewoo/workflow/mailer

**Type**: filter

**Used in**:

- [Workflow_Email.php#L270](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow_Email.php#L270)

## automatewoo/workflow/option

**Type**: filter

**Used in**:

- [Workflow.php#L657](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L657)

## automatewoo/workflow/queue_date

**Type**: filter

**Used in**:

- [Workflow.php#L516](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L516)

## automatewoo/workflow/record_click

**Type**: action

**Used in**:

- [Log.php#L180](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Log.php#L180)

## automatewoo/workflow/record_open

**Type**: action

**Used in**:

- [Log.php#L212](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Log.php#L212)

## automatewoo/workflow/statuses

**Type**: filter

**Used in**:

- [Status.php#L102](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows/Status.php#L102)

## automatewoo/workflow/tax_location

**Type**: filter

**Used in**:

- [Workflow.php#L1721](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1721)

## automatewoo/workflow/types

**Type**: filter

**Used in**:

- [Workflows.php#L45](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows.php#L45)

## automatewoo/workflow/updated

**Type**: action

**Used in**:

- [Workflows.php#L58](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows.php#L58)
- [Factory.php#L131](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows/Factory.php#L131)

## automatewoo/workflows/presets

**Type**: filter

**Used in**:

- [FileStorage.php#L136](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflows/Presets/Storage/FileStorage.php#L136)

## automatewoo_action_option

**Type**: filter

**Used in**:

- [Action.php#L288](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Action.php#L288)

## automatewoo_addon_updated

**Type**: action

**Used in**:

- [addon.php#L161](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/abstracts/addon.php#L161)

## automatewoo_after_action_run

**Type**: action

**Used in**:

- [Workflow.php#L442](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L442)

## automatewoo_after_register_post_types

**Type**: action

**Used in**:

- [Post_Types.php#L66](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Post_Types.php#L66)

## automatewoo_after_workflow_run

**Type**: action

**Used in**:

- [Workflow.php#L450](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L450)

## automatewoo_before_action_run

**Type**: action

**Used in**:

- [Workflow.php#L440](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L440)

## automatewoo_cache_default_expiration

**Type**: filter

**Used in**:

- [Cache.php#L27](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cache.php#L27)

## automatewoo_click_track_url

**Type**: filter

**Used in**:

- [Tracking.php#L58](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Tracking.php#L58)

## automatewoo_conversion_window

**Type**: filter

**Used in**:

- [Conversions.php#L18](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Conversions.php#L18)

## automatewoo_create_pages

**Type**: filter

**Used in**:

- [Installer.php#L301](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L301)

## automatewoo_create_run_log

**Type**: action

**Used in**:

- [Workflow.php#L589](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L589)

## automatewoo_custom_validate_workflow

**Type**: filter

**Used in**:

- [Workflow.php#L329](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L329)

## automatewoo_disable_async_runner

**Type**: filter

**Used in**:

- [AsyncActionRunner.php#L74](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/ActionScheduler/AsyncActionRunner.php#L74)

## automatewoo_email_content

**Type**: filter

**Used in**:

- [Mailer.php#L148](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L148)

## automatewoo_email_footer_separator

**Type**: filter

**Used in**:

- [Mailer.php#L272](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L272)

## automatewoo_email_templates

**Type**: filter

**Used in**:

- [Emails.php#L113](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Emails.php#L113)

## automatewoo_email_unsubscribe_text

**Type**: filter

**Used in**:

- [Workflow_Email.php#L310](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow_Email.php#L310)

## automatewoo_failed_events_delete_after

**Type**: filter

**Used in**:

- [DeleteFailedQueuedWorkflows.php#L48](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Jobs/DeleteFailedQueuedWorkflows.php#L48)

## automatewoo_first_installed

**Type**: action

**Used in**:

- [Installer.php#L117](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L117)

## automatewoo_generate_coupon_default_prefix

**Type**: filter

**Used in**:

- [Coupon_Generator.php#L45](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Coupon_Generator.php#L45)

## automatewoo_init

**Type**: action

**Used in**:

- [AutomateWoo.php#L176](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AutomateWoo.php#L176)

## automatewoo_init_addons

**Type**: action

**Used in**:

- [AutomateWoo.php#L150](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AutomateWoo.php#L150)

## automatewoo_init_triggers

**Type**: action

**Used in**:

- [Triggers.php#L188](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Triggers.php#L188)

## automatewoo_installed

**Type**: action

**Used in**:

- [Installer.php#L106](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L106)

## automatewoo_loaded

**Type**: action

**Used in**:

- [AutomateWoo.php#L248](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AutomateWoo.php#L248)

## automatewoo_new_session_initiated

**Type**: action

**Used in**:

- [Session_Tracker.php#L161](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Session_Tracker.php#L161)

## automatewoo_open_track_url

**Type**: filter

**Used in**:

- [Tracking.php#L30](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Tracking.php#L30)

## automatewoo_order_pending

**Type**: action

**Used in**:

- [Order_Pending.php#L75](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/Order_Pending.php#L75)

## automatewoo_order_pending_check_delay

**Type**: filter

**Used in**:

- [Order_Pending.php#L50](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Events/Order_Pending.php#L50)

## automatewoo_parse_phone_number

**Type**: filter

**Used in**:

- [Phone_Numbers.php#L46](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Phone_Numbers.php#L46)

## automatewoo_register_post_type_aw_workflow

**Type**: filter

**Used in**:

- [Post_Types.php#L28](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Post_Types.php#L28)

## automatewoo_text_variable_value

**Type**: filter

**Used in**:

- [Variables_Processor.php#L119](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables_Processor.php#L119)

## automatewoo_trigger_option

**Type**: filter

**Used in**:

- [Trigger.php#L370](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Trigger.php#L370)

## automatewoo_unsubscribe_url

**Type**: filter

**Used in**:

- [Workflow.php#L1205](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1205)
- [Workflow.php#L1218](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Workflow.php#L1218)

## automatewoo_updated

**Type**: action

**Used in**:

- [Installer.php#L285](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L285)

## automatewoo_validate_data_item

**Type**: filter

**Used in**:

- [helpers.php#L109](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/helpers.php#L109)

## automatewoo_version_changed

**Type**: action

**Used in**:

- [Installer.php#L95](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L95)

## automatewoo_visitor_tracking_cookie_expiry

**Type**: filter

**Used in**:

- [Session_Tracker.php#L35](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Session_Tracker.php#L35)

## edit_term_taxonomy

**Type**: action

**Used in**:

- [User_Tags.php#L121](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/User_Tags.php#L121)

## edited_term_taxonomy

**Type**: action

**Used in**:

- [User_Tags.php#L123](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/User_Tags.php#L123)

## https_local_ssl_verify

**Type**: filter

**Used in**:

- [Async_Request_Abstract.php#L40](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Async_Request_Abstract.php#L40)
- [AW_AsyncRequest_QueueRunner.php#L37](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/ActionScheduler/AW_AsyncRequest_QueueRunner.php#L37)

## wc_get_template

**Type**: filter

**Used in**:

- [Mailer.php#L325](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L325)

## woocommerce_add_to_cart_product_id

**Type**: filter

**Used in**:

- [Frontend_Endpoints.php#L129](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Endpoints.php#L129)

## woocommerce_add_to_cart_validation

**Type**: filter

**Used in**:

- [Frontend_Endpoints.php#L150](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Endpoints.php#L150)

## woocommerce_admin_disabled

**Type**: filter

**Used in**:

- [WcAdminDisabled.php#L29](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AdminNotices/WcAdminDisabled.php#L29)

## woocommerce_after_resend_order_email

**Type**: action

**Used in**:

- [Subscription_Send_Invoice.php#L35](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Subscription_Send_Invoice.php#L35)
- [Order_Resend_Email.php#L94](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Order_Resend_Email.php#L94)

## woocommerce_after_template_part

**Type**: action

**Used in**:

- [Mailer.php#L332](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L332)

## woocommerce_before_resend_order_emails

**Type**: action

**Used in**:

- [Subscription_Send_Invoice.php#L29](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Subscription_Send_Invoice.php#L29)
- [Order_Resend_Email.php#L73](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Order_Resend_Email.php#L73)

## woocommerce_before_template_part

**Type**: action

**Used in**:

- [Mailer.php#L326](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L326)

## woocommerce_cart_item_name

**Type**: filter

**Used in**:

- [Cart_Item.php#L77](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart_Item.php#L77)

## woocommerce_email_customer_details

**Type**: action

**Used in**:

- [Order_Customer_Details.php#L27](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Variables/Order_Customer_Details.php#L27)

## woocommerce_email_styles

**Type**: filter

**Used in**:

- [Mailer.php#L254](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L254)

## woocommerce_enable_auto_update_db

**Type**: filter

**Used in**:

- [addon.php#L115](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/abstracts/addon.php#L115)
- [Installer.php#L60](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Installer.php#L60)

## woocommerce_get_item_data

**Type**: filter

**Used in**:

- [Cart_Item.php#L218](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart_Item.php#L218)

## woocommerce_is_rest_api_request

**Type**: filter

**Used in**:

- [AutomateWoo.php#L318](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/AutomateWoo.php#L318)

## woocommerce_mail_content

**Type**: filter

**Used in**:

- [Mailer.php#L133](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Mailer.php#L133)

## woocommerce_order_action_sanitize_title

**Type**: action

**Used in**:

- [Order_Trigger_Action.php#L84](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Order_Trigger_Action.php#L84)

## woocommerce_order_actions

**Type**: filter

**Used in**:

- [Order_Trigger_Action.php#L57](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Actions/Order_Trigger_Action.php#L57)

## woocommerce_order_again_cart_item_data

**Type**: filter

**Used in**:

- [Frontend_Endpoints.php#L133](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Endpoints.php#L133)

## woocommerce_ordered_again

**Type**: action

**Used in**:

- [Frontend_Endpoints.php#L157](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Frontend_Endpoints.php#L157)

## woocommerce_product_variation_title_attributes_separator

**Type**: filter

**Used in**:

- [helpers.php#L851](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/helpers.php#L851)

## woocommerce_product_variation_title_include_attributes

**Type**: filter

**Used in**:

- [helpers.php#L850](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/helpers.php#L850)

## woocommerce_rest_->POST->POST_TYPE_trashable

**Type**: filter

**Used in**:

- [DeleteWorkflow.php#L40](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Rest_Api/Utilities/DeleteWorkflow.php#L40)

## woocommerce_variation_option_name

**Type**: filter

**Used in**:

- [Cart_Item.php#L202](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/includes/Cart_Item.php#L202)

## automatewoo/communication_form/after_subscribe_preference

**Type**: action

**Used in**:

- [communication-preferences-list.php#L48](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/communication-preferences/communication-preferences-list.php#L48)

## automatewoo/communication_preferences/default_to_checked

**Type**: filter

**Used in**:

- [communication-preferences-list.php#L25](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/communication-preferences/communication-preferences-list.php#L25)

## automatewoo/honeypot_field/name

**Type**: filter

**Used in**:

- [honeypot-field.php#L17](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/honeypot-field.php#L17)

## automatewoo/show_plain_text_footer_when_no_unsubscribe_link

**Type**: filter

**Used in**:

- [email-footer.php#L13](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/email/plain/email-footer.php#L13)

## woocommerce_email_footer_text

**Type**: filter

**Used in**:

- [email-footer.php#L16](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/email/plain/email-footer.php#L16)

## woocommerce_email_order_details

**Type**: action

**Used in**:

- [order-table.php#L18](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/templates/email/order-table.php#L18)

## automatewoo_activated

**Type**: action

**Used in**:

- [automatewoo.php#L223](https://github.com/woocommerce/automatewoo/blob/9d530c1b4dd67efc4a1e27b5cc1cda238d3b130b/automatewoo.php#L223)

